import bpy
from bpy.types import Panel
from ...addon.naming import FluidLabNaming
from ..ui_module_panel import FLUIDLAB_ModulePanel
from ...libs.functions.get_common_vars import get_common_vars
from ...libs.functions.common_ui_elements import title_header, collapsable, multiline_print
# from bl_ui.properties_physics_common import effector_weights_ui


def effector_weights_ui(layout, weight_type, surface):

    # NOTA: es el de bl_ui.properties_physics_common pero modificado el self por el layout.

    layout.use_property_split = True

    # NOTE: TODO temporarily used until the animate properties are properly skipped.
    layout.use_property_decorate = False  # No animation (remove this later on).

    layout.prop(surface, "collection")

    flow = layout.grid_flow(row_major=True, columns=0, even_columns=True, even_rows=False, align=True)

    col = flow.column()
    col.prop(surface, "gravity", slider=True)
    col.prop(surface, "all", slider=True)
    col.prop(surface, "force", slider=True)
    col.prop(surface, "vortex", slider=True)

    col = flow.column()
    col.prop(surface, "magnetic", slider=True)
    col.prop(surface, "harmonic", slider=True)
    col.prop(surface, "charge", slider=True)
    col.prop(surface, "lennardjones", slider=True)

    col = flow.column()
    col.prop(surface, "wind", slider=True)
    col.prop(surface, "curve_guide", slider=True)
    col.prop(surface, "texture", slider=True)

    if weight_type != 'FLUID':
        col.prop(surface, "smokeflow", slider=True)

    col = flow.column()
    col.prop(surface, "turbulence", slider=True)
    col.prop(surface, "drag", slider=True)
    col.prop(surface, "boid", slider=True)


def canvas_settings(layout, canvas, surface):

    if canvas is None:
        layout.operator("dpaint.type_toggle", text="Add Canvas").type = 'CANVAS'
        return  # do nothing.
    
    # layout.operator("dpaint.type_toggle", text="Remove Canvas", icon='X').type = 'CANVAS'

    # Listado que no pondre:
    # row = layout.row()
    # row.template_list("PHYSICS_UL_dynapaint_surfaces", "", canvas, "canvas_surfaces", canvas.canvas_surfaces, "active_index", rows=1)
    # col = row.column(align=True)
    # col.operator("dpaint.surface_slot_add", icon='ADD', text="")
    # col.operator("dpaint.surface_slot_remove", icon='REMOVE', text="")

    # layout.separator()

    if not surface:
        return
    
    layout.use_property_split = True
    
    flow = layout.grid_flow(
        row_major=True, columns=0, even_columns=True, even_rows=False, align=False,
    )
    col = flow.column()

    col.prop(surface, "surface_format")

    if surface.surface_format != 'VERTEX':
        col.prop(surface, "image_resolution")
    
    col.prop(surface, "use_antialiasing")

    col = flow.column(align=True)
    col.prop(surface, "frame_start", text="Frame Start")
    col.prop(surface, "frame_end", text="End")

    col.prop(surface, "frame_substeps")


def initial_color(layout, surface, collider_ob):
    col = layout.column()
    col.prop(surface, "init_color_type", text="Type", expand=False)

    if surface.init_color_type != 'NONE':
        col.separator()

    # dissolve
    if surface.init_color_type == 'COLOR':
        layout.prop(surface, "init_color")

    elif surface.init_color_type == 'TEXTURE':
        col.prop(surface, "init_texture")
        col.prop_search(surface, "init_layername", collider_ob.data, "uv_layers", text="UV Map")

    elif surface.init_color_type == 'VERTEX_COLOR':
        col.prop_search(surface, "init_layername", collider_ob.data, "vertex_colors", text="Color Layer")


def surface_settings(toggles, main_col, layout, surface, collider_ob):
    surface_type = surface.surface_type

    layout.prop(surface, "surface_type")

    layout.separator()

    flow = layout.grid_flow(row_major=True, columns=0, even_columns=True, even_rows=False, align=True)

    # per type settings
    if surface_type == 'DISPLACE':
        col = flow.column()

        if surface.surface_format == 'VERTEX':
            col.prop(surface, "depth_clamp")
            col.prop(surface, "displace_factor")

        col.prop(surface, "use_incremental_displace")
        col.separator()

    elif surface_type == 'WAVE':
        col = flow.column()
        col.prop(surface, "use_wave_open_border")
        col.prop(surface, "wave_timescale")
        col.prop(surface, "wave_speed")

        col.separator()

        col = flow.column()
        col.prop(surface, "wave_damping")
        col.prop(surface, "wave_spring")
        col.prop(surface, "wave_smoothness")

        col.separator()

    col = flow.column()
    col.prop(surface, "brush_collection")

    if surface_type not in {'DISPLACE', 'WAVE'}:
        col = flow.column()  # flow the layout otherwise.

    col.prop(surface, "brush_influence_scale", text="Scale Influence")
    col.prop(surface, "brush_radius_scale", text="Radius")


    if surface.surface_type != 'WAVE':

        # Dissolve:
        flow_dissolve = flow.grid_flow(row_major=True, columns=3, even_columns=False, even_rows=False, align=True)
        
        subrow0 = flow_dissolve.box().row(align=True)
        subrow0.alignment = 'RIGHT'
        subrow0.label(text="Dissolve")
        subrow0.prop(surface, "use_dissolve", text="")

        subrow1 = flow_dissolve.box().row(align=True)
        subrow1.scale_x = 0.9
        subrow1.prop(surface, "dissolve_speed", text="Time")        
        subrow1.active = surface.use_dissolve

        subrow2 = flow_dissolve.box().row(align=True)
        subrow2.scale_x = 0.9
        subrow2.alignment = 'LEFT'
        subrow2.label(text="Slow")
        subrow2.prop(surface, "use_dissolve_log", text=" ")
        subrow2.active = surface.use_dissolve


    if surface.surface_type == 'PAINT':

        flow_dissolve = flow.grid_flow(row_major=True, columns=4, even_columns=False, even_rows=False, align=True)
        
        # Dry
        subrow0 = flow_dissolve.box().row(align=True)
        subrow0.alignment = 'RIGHT'
        subrow0.scale_x = 1.3
        subrow0.label(text="Dry   ")
        subrow0.prop(surface, "use_drying", text="")

        subrow1 = flow_dissolve.box().row(align=True)
        subrow1.scale_x = 0.6
        subrow1.prop(surface, "dry_speed", text="Time | Color")
        subrow1.prop(surface, "color_dry_threshold", text="")
        subrow1.active = surface.use_drying
        
        subrow3 = flow_dissolve.box().row(align=True)
        subrow3.alignment = 'LEFT'
        subrow3.scale_x = 0.9
        subrow3.label(text="Slow")
        subrow3.prop(surface, "use_dry_log", text=" ")
        subrow3.active = surface.use_drying

    ic = collapsable(
        main_col,
        toggles,
        "initial_color",
        "Initial Color",
        'RESTRICT_COLOR_ON',
        align=False,
    )
    if ic:
        initial_color(ic, surface, collider_ob)


def effects_settigns(toggles, main_col, layout, surface):

    # Spread:
    layout.prop(surface, "use_spread", text="Spread")
    flow = layout.grid_flow(row_major=True, columns=0, even_columns=True, even_rows=False, align=False)
    flow.enabled = surface.use_spread
    flow.prop(surface, "spread_speed", text="Speed")
    flow.prop(surface, "color_spread_speed", text="Color")

    layout = main_col.box().column(align=True)

    # Drip:
    layout.prop(surface, "use_drip", text="Drip")
    flow = layout.grid_flow(row_major=True, columns=0, even_columns=True, even_rows=False, align=False)
    flow.active = surface.use_drip
    flow.prop(surface, "drip_velocity", slider=True)
    flow.prop(surface, "drip_acceleration", slider=True)

    # Drip Weights:
    layout.active = surface.use_drip

    layout.separator()
    ew = collapsable(
        layout,
        toggles,
        "canvas_effects_weights",
        "Drip Weights",
        'FORCE_MAGNETIC',
        align=False,
    )
    if ew:
        effector_weights_ui(ew, 'DYNAMIC_PAINT', surface)

    layout = main_col.box().column(align=True)

    # Shrink:
    layout.prop(surface, "use_shrink", text="Shrink")
    shrink = layout.column(align=True)
    shrink.active = surface.use_shrink
    shrink.prop(surface, "shrink_speed", text="Speed")


def point_cache_ui(layout, cache, enabled, cachetype):
    layout.use_property_split = True

    layout.context_pointer_set("point_cache", cache)

    is_saved = bpy.data.is_saved
    is_liboverride = cache.id_data.override_library is not None

    # NOTE: TODO temporarily used until the animate properties are properly skipped.
    layout.use_property_decorate = False  # No animation (remove this later on).

    if not cachetype == 'RIGID_BODY':
        row = layout.row()
        row.template_list(
            "UI_UL_list", "point_caches", cache, "point_caches",
            cache.point_caches, "active_index", rows=1,
        )
        col = row.column(align=True)
        col.operator("ptcache.add", icon='ADD', text="")
        col.operator("ptcache.remove", icon='REMOVE', text="")

    if cachetype in {'PSYS', 'HAIR', 'FLUID'}:
        col = layout.column()

        if cachetype == 'FLUID':
            col.prop(cache, "use_library_path", text="Use Library Path")

        col.prop(cache, "use_external")

    if cache.use_external:
        col = layout.column()
        col.prop(cache, "index", text="Index")
        col.prop(cache, "filepath", text="Path")

        cache_info = cache.info
        if cache_info:
            col = layout.column()
            col.alignment = 'RIGHT'
            col.label(text=cache_info)
    else:
        if cachetype in {'FLUID', 'DYNAMIC_PAINT'}:
            if not is_saved:
                col = layout.column(align=True)
                col.alignment = 'RIGHT'
                col.label(text="Cache is disabled until the file is saved")
                layout.enabled = False

    if not cache.use_external or cachetype == 'FLUID':
        col = layout.column(align=True)

        if cachetype not in {'PSYS', 'DYNAMIC_PAINT'}:
            col.enabled = enabled
            col.prop(cache, "frame_start", text="Simulation Start")
            col.prop(cache, "frame_end")

        if cachetype not in {'FLUID', 'CLOTH', 'DYNAMIC_PAINT', 'RIGID_BODY'}:
            col.prop(cache, "frame_step")

        cache_info = cache.info
        if cachetype != 'FLUID' and cache_info:  # avoid empty space.
            col = layout.column(align=True)
            col.alignment = 'RIGHT'
            col.label(text=cache_info)

        can_bake = True

        if cachetype not in {'FLUID', 'DYNAMIC_PAINT', 'RIGID_BODY'}:
            if not is_saved:
                col = layout.column(align=True)
                col.alignment = 'RIGHT'
                col.label(text="Options are disabled until the file is saved")

            flow = layout.grid_flow(row_major=True, columns=0, even_columns=True, even_rows=False, align=True)
            flow.enabled = enabled and is_saved

            col = flow.column(align=True)
            col.prop(cache, "use_disk_cache")

            subcol = col.column()
            subcol.active = cache.use_disk_cache
            subcol.prop(cache, "use_library_path", text="Use Library Path")

            col = flow.column()
            col.active = cache.use_disk_cache
            col.prop(cache, "compression", text="Compression")

            if cache.id_data.library and not cache.use_disk_cache:
                can_bake = False

                col = layout.column(align=True)
                col.alignment = 'RIGHT'

                col.separator()

                col.label(text="Linked object baking requires Disk Cache to be enabled")
        else:
            layout.separator()

        flow = layout.grid_flow(row_major=True, columns=0, even_columns=True, even_rows=False, align=False)
        col = flow.column()
        col.active = can_bake

        if is_liboverride and not cache.use_disk_cache:
            col.operator("ptcache.bake", icon='ERROR', text="Bake (Disk Cache mandatory)")
        elif cache.is_baked is True:
            col.operator("ptcache.free_bake", text="Delete Bake")
        else:
            col.operator("ptcache.bake", text="Bake").bake = True

        sub = col.row()
        sub.enabled = enabled
        sub.operator("ptcache.bake", text="Calculate to Frame").bake = False

        sub = col.column()
        sub.enabled = enabled
        sub.operator("ptcache.bake_from_cache", text="Current Cache to Bake")

        col = flow.column()
        col.operator("ptcache.bake_all", text="Bake All Dynamics").bake = True
        col.operator("ptcache.free_bake_all", text="Delete All Bakes")
        col.operator("ptcache.bake_all", text="Update All to Frame").bake = False


def output_ui(main_col, layout, surface, ob):
    layout.use_property_split = True

    surface_type = surface.surface_type

    # vertex format outputs.
    if surface.surface_format == 'VERTEX':
        if surface_type == 'PAINT':

            # paint-map output.
            row = layout.row()
            row.prop_search(surface, "output_name_a", ob.data, "vertex_colors", text="Paintmap Layer")

            icons = 'REMOVE' if surface.output_exists(object=ob, index=0) else 'ADD'
            row.operator("dpaint.output_toggle", icon=icons, text="").output = 'A'

            # wet-map output.
            row = layout.row()
            row.prop_search(surface, "output_name_b", ob.data, "vertex_colors", text="Wetmap Layer")

            icons = 'REMOVE' if surface.output_exists(object=ob, index=1) else 'ADD'
            row.operator("dpaint.output_toggle", icon=icons, text="").output = 'B'

        elif surface_type == 'WEIGHT':
            row = layout.row()
            row.prop_search(surface, "output_name_a", ob, "vertex_groups", text="Vertex Group")

            icons = 'REMOVE' if surface.output_exists(object=ob, index=0) else 'ADD'
            row.operator("dpaint.output_toggle", icon=icons, text="").output = 'A'

    # image format outputs.
    if surface.surface_format == 'IMAGE':

        layout.operator("dpaint.bake", text="Bake Image Sequence", icon='MOD_DYNAMICPAINT')

        layout.prop(surface, "image_output_path", text="Cache Path")

        flow = layout.grid_flow(row_major=True, columns=0, even_columns=True, even_rows=False, align=False)

        col = flow.column()

        col.prop_search(surface, "uv_layer", ob.data, "uv_layers", text="UV Map")

        col = flow.column()
        col.prop(surface, "image_fileformat")
        col.prop(surface, "use_premultiply", text="Premultiply Alpha")

        if surface_type != 'PAINT':
            col = col.column()
            col.prop(surface, "output_name_a", text="Filename")

            if surface_type == 'DISPLACE':
                col.prop(surface, "displace_type", text="Displace Type")
                col.prop(surface, "depth_clamp")

            elif surface_type == 'WAVE':
                col.prop(surface, "depth_clamp", text="Wave Clamp")
        
        else: # <- surface_type == 'PAINT'
        
            # Paintmaps:
            maps = main_col.row(align=True)
            maps.use_property_split = False

            layout = maps.box().column(align=True)
            row = layout.row(align=True)
            row.alignment = 'RIGHT'
            
            row.prop(surface, "use_output_a", text="")
            sub = row.column(align=True)
            sub.active = surface.use_output_a
            sub.prop(surface, "output_name_a", text=" Paintmaps")
            
            # Wetmaps:
            row = layout.row(align=True)
            row.alignment = 'RIGHT'
            
            row.prop(surface, "use_output_b", text="")
            sub = row.column(align=True)
            sub.active = surface.use_output_b
            sub.prop(surface, "output_name_b", text=" Wetmaps")


def brushes_settings(layout, brush):
    
    if not brush:
        return

    layout.use_property_split = True

    flow = layout.grid_flow(
        row_major=True, columns=0, even_columns=True, even_rows=False, align=False,
    )
    col = flow.column()
    col.prop(brush, "paint_color")
    col.prop(brush, "paint_alpha", text="Alpha", slider=True)

    col = flow.column()
    col.prop(brush, "paint_wetness", text="Wetness", slider=True)
    col.prop(brush, "use_absolute_alpha")
    col.prop(brush, "use_paint_erase")


def brush_source(layout, ob, brush):
    layout.prop(brush, "paint_source", text="Paint")

    flow = layout.grid_flow(row_major=True, columns=0, even_columns=True, even_rows=False, align=False)

    if brush.paint_source == 'PARTICLE_SYSTEM':
        col = flow.column()

        col.separator()

        col.prop_search(brush, "particle_system", ob, "particle_systems")

        if brush.particle_system:
            col = flow.column()

            sub = col.column()
            sub.active = not brush.use_particle_radius
            sub.prop(brush, "solid_radius", text="Effect Solid Radius")

            col.prop(brush, "use_particle_radius", text="Use Particle's Radius")
            col.prop(brush, "smooth_radius", text="Smooth Radius")

    if brush.paint_source in {'DISTANCE', 'VOLUME_DISTANCE', 'POINT'}:
        col = flow.column()

        col.separator()

        col.prop(brush, "paint_distance", text="Distance")
        col.prop(brush, "proximity_falloff")

        if brush.paint_source == 'VOLUME_DISTANCE':
            col.prop(brush, "invert_proximity")

            col = flow.column()
            col.prop(brush, "use_negative_volume")

        if brush.paint_source in {'DISTANCE', 'VOLUME_DISTANCE'}:
            col = flow.column() if brush.paint_source != 'VOLUME_DISTANCE' else col.column()
            col.prop(brush, "use_proximity_project")

            sub = col.column()
            sub.active = brush.use_proximity_project
            sub.prop(brush, "ray_direction")


def brush_velocity(main_col, layout, brush, toggles):

    flow = layout.grid_flow(row_major=True, columns=0, even_columns=True, even_rows=False, align=False)
    col = flow.column()
    col.prop(brush, "use_velocity_alpha")
    col.prop(brush, "use_velocity_color")

    col = flow.column()
    col.prop(brush, "use_velocity_depth")
    sub = col.column()
    sub.active = (brush.use_velocity_alpha or brush.use_velocity_color or brush.use_velocity_depth)
    sub.prop(brush, "velocity_max")

    b_vel_ramp = collapsable(
        main_col,
        toggles,
        "brush_velocity_ramp",
        "Ramp",
        'COLORSET_13_VEC',
        align=False,
    )
    if b_vel_ramp:
        b_vel_ramp.template_color_ramp(brush, "velocity_ramp", expand=True)
    

    b_vel_smudge = collapsable(
        main_col,
        toggles,
        "brush_velocity_smudge",
        "Smudge",
        'NODE_TEXTURE',
        align=False,
    )
    if b_vel_smudge:

        smudge = b_vel_smudge.row(align=True)
        smudge.prop(brush, "use_smudge", text="Smudge")
        sub_smudge = smudge.row(align=True)
        sub_smudge.active = brush.use_smudge
        sub_smudge.prop(brush, "smudge_strength", text="Strength", slider=True)


def brush_waves(layout, brush):
    layout.prop(brush, "wave_type", text="Type")

    flow = layout.grid_flow(row_major=True, columns=0, even_columns=True, even_rows=False, align=True)

    if brush.wave_type != 'REFLECT':
        col = flow.column()
        col.prop(brush, "wave_factor")

        col = flow.column()
        col.prop(brush, "wave_clamp")


class FLUIDLAB_PT_dynamic_paint_ui(Panel, FLUIDLAB_ModulePanel):
    fluidlab_section = 'DYNAMIC_PAINT'
    bl_idname = "FLUIDLAB_PT_dynamic_paint_ui"
    bl_label = "Module"


    def draw(self, context):
        
        fluidlab, fluid_mesh, fluid_colliders, fluid_single_colliders, ui, toggles = get_common_vars(context, fluidlab=True, get_fluid_mesh=True, get_fluid_colliders=True, get_fluid_single_colliders=True, get_ui=True, get_toggles=True)

        dp_props = fluidlab.dynamic_paint

        layout = self.layout
        layout.use_property_split = True
        layout.use_property_decorate = False

        col = layout.column(align=True)
        title_header(col, "Dynamic Paint")

        main_col = col.box().column(align=True)
        main_col.use_property_split = True
        main_col.use_property_decorate = False

        if ui.ui_mode == 'BASIC':
        
            # ------------- #
            """ UI BASICA """
            # ------------- #
        
            main_col.label(text="Hola Mundo Basico")

    
        elif ui.ui_mode == 'ADVANCED':
        
            # --------------- #
            """ UI AVANZADA """
            # --------------- # 

            subsections_header = main_col.row(align=True)
            subsections_header.use_property_split = False
            subsections_header.scale_y = 1.3
            subsections_header.prop(dp_props, "dp_sections", expand=True)
            main_col.separator()

            if dp_props.dp_sections == 'BRUSHES':
                
                # BRUSHESH
                active_mesh = fluid_mesh.active
                if not active_mesh:
                    main_col.box().label(text=FluidLabNaming.NO_MESHES_AVAIL, icon='INFO')
                    return
                
                brush_mesh_ob = active_mesh.ob
                md = brush_mesh_ob.modifiers.get(FluidLabNaming.DP_CANVAS_MOD)

                main_col.template_list("FLUIDLAB_UL_draw_fluids_mesh", "", fluid_mesh, "list", fluid_mesh, "list_index", rows=3)
                
                add_bt = main_col.row(align=True)
                add_bt.scale_y = 1.3
                add_bt.operator("fluidlab.dynamic_paint_add_brush", text="Add Brush")

                if not md:
                    return
                
                # Mostrar feedback de brushes solo si hay mas de 1 emisor:
                all_group_items = fluidlab.lists.fluid_groups.get_all_items
                total_emitters = sum(group_item.emitters.length for group_item in all_group_items)
                if total_emitters > 1:
                    main_col.separator()
                    text="It is necessary to bake Dinamic Paint and then remove the brushes in order to render correctly."
                    multiline_print(main_col, text, 8, 'INFO')
                
                brush = md.brush_settings

                main_col.separator()

                # Brush Settings:

                b_settings = collapsable(
                    main_col,
                    toggles,
                    "brush_settings",
                    "Settings",
                    'BRUSH_DATA',
                    align=False,
                )
                if b_settings:
                    brushes_settings(b_settings, brush)
                
                main_col.separator()
                
                b_source = collapsable(
                    main_col,
                    toggles,
                    "brush_source",
                    "Source",
                    'TPAINT_HLT',
                    align=False,
                )
                if b_source:
                    brush_source(b_source, brush_mesh_ob, brush)
                
                main_col.separator()

                b_velocity = collapsable(
                    main_col,
                    toggles,
                    "brush_velocity",
                    "Velocity",
                    'IPO_EASE_IN_OUT',
                    align=False,
                )
                if b_velocity:
                    brush_velocity(main_col, b_velocity, brush, toggles)
                
                main_col.separator()

                b_waves = collapsable(
                    main_col,
                    toggles,
                    "brush_waves",
                    "Waves",
                    'MOD_WAVE',
                    align=False,
                )
                if b_waves:
                    brush_waves(b_waves, brush)
                
            else:

                # CANVAS

                active_collider = fluid_single_colliders.active
                if not active_collider:
                    main_col.box().label(text=FluidLabNaming.NO_COLLIDERS_AVAIL, icon='INFO')
                    return
                
                main_col.template_list("FLUIDLAB_UL_draw_fluids_single_colliders", "", fluid_single_colliders, "list", fluid_single_colliders, "list_index", rows=3)

                add_bt = main_col.row(align=True)
                add_bt.scale_y = 1.3
                add_bt.operator("fluidlab.dynamic_paint_add_canvas", text="Add Canvas")

                # Canvas Settings:
                colliders_ob = active_collider.collider
               
                md = colliders_ob.modifiers.get(FluidLabNaming.DP_CANVAS_MOD)
                if not md or md.ui_type != 'CANVAS':
                    # Si no hay modifier de canvas no se dibuja la ui:
                    return
                
                main_col.separator()
                
                canvas = md.canvas_settings
                surface = canvas.canvas_surfaces.active

                cs = collapsable(
                    main_col,
                    toggles,
                    "canvas_settings",
                    "Settings",
                    'TEXTURE',
                    align=False,
                )
                if cs:
                    canvas_settings(cs, canvas, surface)
                
                main_col.separator()


                ss = collapsable(
                    main_col,
                    toggles,
                    "surface_settings",
                    "Surface Settings",
                    'NODE_MATERIAL',
                    align=False,
                )
                if ss:
                    surface_settings(toggles, main_col, ss, surface, colliders_ob)
                
                main_col.separator()

                c_effects = collapsable(
                    main_col,
                    toggles,
                    "canvas_effects",
                    "Effects",
                    'EXPERIMENTAL',
                    align=False,
                )
                if c_effects:
                    effects_settigns(toggles, main_col, c_effects, surface)

                # Si estamos en image sequencer ocultamos el bloque de cache:
                if surface.surface_format != 'IMAGE':
                    
                    main_col.separator()
                    
                    cache_s = collapsable(
                        main_col,
                        toggles,
                        "cache_settings",
                        "Cache",
                        'FILE_CACHE',
                        align=False,
                    )
                    if cache_s:
                        surface = canvas.canvas_surfaces.active
                        cache = surface.point_cache
                        point_cache_ui(cache_s, cache, (cache.is_baked is False), 'DYNAMIC_PAINT')
                
                main_col.separator()

                output_s = collapsable(
                    main_col,
                    toggles,
                    "output_settings",
                    "Output",
                    'FILE_CACHE',
                    align=False,
                )
                if output_s:            
                    output_ui(main_col, output_s, surface, colliders_ob)
                
                # Pospuesto:
                # # Test blur images con pillow:
                # if surface.surface_format == 'IMAGE':
                #     main_col.separator()

                #     buttons = main_col.row(align=True)
                #     buttons.scale_y = 1.3

                #     # se pospone el Blur:
                #     # buttons.operator("fluidlab.dynamic_paint_blur")
                #     buttons.operator("fluidlab.dynamic_add_mat_img_sequence")